<?php

namespace App\Repositories\Focus\question;

use DB;
use Carbon\Carbon;
use App\Models\question\Question;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use App\Models\question\QuestionItem;

/**
 * Class QuestionRepository.
 */
class QuestionRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = Question::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {

        return $this->query()
            ->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        DB::beginTransaction();
        $data = $input['data'];
        $result = Question::create($data);
        $data_items = $input['data_items'];
        $data_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'question_id' => $result->id, 
                'ins' => $result->ins,
                'user_id' => $result->user_id,
            ]);
        }, $data_items);
        // dd($data_items);
        QuestionItem::insert($data_items);
        if ($result) {
            DB::commit();
            return $result;
        }
        throw new GeneralException(trans('exceptions.backend.Questions.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Question $Question
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update($question, array $input)
    {
        DB::beginTransaction();
        // dd($input);
        $data = $input['data'];
        $result = $question->update($data);

        $data_items = $input['data_items'];
        // remove omitted items
        $item_ids = array_map(function ($v) { return $v['id']; }, $data_items);
        $question->items()->whereNotIn('id', $item_ids)->delete();
        // create or update items
        foreach($data_items as $item) {
           
            $question_item = QuestionItem::firstOrNew(['id' => $item['id']]);
            $question_item->fill(array_replace($item, ['question_id' => $question['id'], 'ins' => $question['ins']]));
            if (!$question_item->id) unset($question_item->id);
            $question_item->save();
        }
        if ($result) {
            DB::commit();
            return $question;      
        }
        throw new GeneralException(trans('exceptions.backend.Questions.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Question $Question
     * @throws GeneralException
     * @return bool
     */
    public function delete(Question $question)
    {
        if ($question->delete() && $question->items->each->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.Questions.delete_error'));
    }
}
