<?php

namespace App\Repositories\Focus\purchase_request;

use App\Exceptions\GeneralException;
use App\Models\purchase_request\PurchaseRequest;
use App\Repositories\BaseRepository;
use App\Models\purchase_request\PurchaseRequestItem;
use Illuminate\Support\Facades\DB;

class PurchaseRequestRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = PurchaseRequest::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = $this->query();
        $q->when(request('requisition_rejected'), function ($q) {
            $q->where('status', request('requisition_rejected'));
        });
        $q->when(request('requisition_approved'), function ($q) {
            $q->where('status', request('requisition_pending'));
        });
        $q->when(request('requisition_completed'), function ($q) {
            $q->where('purchase_status', request('requisition_completed'));
        });
        $q->when(request('purchase_status'), function ($q) {
            $q->where('purchase_status', request('purchase_status'));
        });
        return $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return PurchaseRequest $purchase_request
     */
    public function create(array $input)
    {
       //  dd($input);
        DB::beginTransaction();
         $data = $input['data'];
        foreach ($data as $key => $val) {
            if (in_array($key, ['date', 'expect_date'])) 
                $data[$key] = date_for_database($val);
        }

        $tid = PurchaseRequest::where('ins', auth()->user()->ins)->max('tid');
        if ($data['tid'] <= $tid) $data['tid'] = $tid+1;
        
        $result = PurchaseRequest::create($data);

        $data_items = $input['data_items'];
        $data_items = array_map(function($v) use ($result){
            return array_replace($v,[
                'ins' => $result->ins,
                'user_id' => $result->user_id,
                'requisition_id' => $result->id,
                'requisition_item_type' => $result->item_type,
            ]);
        }, $data_items);
        PurchaseRequestItem::insert($data_items);
        if ($result){
            DB::commit();
            return $result;
        }
        
            
        throw new GeneralException(trans('exceptions.backend.leave_category.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param PurchaseRequest $purchase_request
     * @param  array $input
     * @throws GeneralException
     * return bool
     */
    public function update(PurchaseRequest $purchase_request, array $input)
    {
        //dd($input);
        DB::beginTransaction();
        $data = $input['data'];
        foreach ($data as $key => $val) {
            if (in_array($key, ['date', 'expect_date'])) 
                $data[$key] = date_for_database($val);
        }
        $result = $purchase_request->update($data);
        $data_items = $input['data_items'];
        // remove omitted items
        $item_ids = array_map(function ($v) { return $v['id']; }, $data_items);
        $purchase_request->items()->whereNotIn('id', $item_ids)->delete();

        // create or update items
        foreach($data_items as $item) {
            $data_item = PurchaseRequestItem::firstOrNew(['id' => $item['id']]);
            $data_item->fill(array_replace($item, 
                ['requisition_id' => $purchase_request['id'],
                 'ins' => $purchase_request['ins'],
                 'requisition_item_type' => $purchase_request['item_type']
                ]));
            if (!$data_item->id) unset($data_item->id);
            $data_item->save();
        }
        if ($result) {
            DB::commit();
            return $purchase_request;      
        }

        throw new GeneralException(trans('exceptions.backend.leave_category.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param PurchaseRequest $purchase_request
     * @throws GeneralException
     * @return bool
     */
    public function delete(PurchaseRequest $purchase_request)
    {
        if ($purchase_request->delete() && $purchase_request->items->each->delete()) return true;
            
        throw new GeneralException(trans('exceptions.backend.leave_category.delete_error'));
    }
}
