<?php

namespace App\Repositories\Focus\project;

use App\Http\Utilities\Notification;
use App\Models\Access\User\User;
use App\Models\event\Event;
use App\Models\event\EventRelation;
use App\Models\project\ProjectLog;
use App\Models\project\ProjectRelations;
use App\Models\project\TaskRelations;
use App\Notifications\Rose;
use DB;
use Carbon\Carbon;
use App\Models\project\Task;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use App\Models\jobcard\JobCard;
use App\Models\project\Project;
use App\Models\project\MilestoneJobCard;

/**
 * Class TaskRepository.
 */
class TaskRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = Task::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable($uid = 0)
    {
        $q = $this->query();
        $q->when(request('project_id'), function($q) {
            $q->whereHas('project', fn($q) => $q->where('projects.id', request('project_id')));
        });
        return $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @return Task $task
     * @throws GeneralException
     */
    public function create(array $input)
    {
        // dd($input);
        
        DB::beginTransaction();
        $input['start_date'] = datetime_for_database($input['start_date']);
        $input['end_date'] = datetime_for_database($input['end_date']);
        $input['qty_needed'] = floatval(str_replace(',', '', $input['qty_needed']));
        if($input['jobcard_id']){
            $jobcard = JobCard::find($input['jobcard_id']);
            $project = Project::find($input['project_id']);
            $project->qty_needed += $jobcard->total_qty;
            $project->update();
            $input['qty_needed'] = $jobcard->total_qty;
        }else{
            throw new GeneralException('Attach JobCard!!');
        }
        // dd($input);


        
        $result = Task::create($input);
        if($result->jobcard_id){
            $data = ['task_id'=>$result->id, 'jobcard_id'=>$result->jobcard_id];
            MilestoneJobCard::create($data);
        }
        
        if ($result) {
            DB::commit();
            return $result;
        }

        throw new GeneralException(trans('exceptions.backend.tasks.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Task $task
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(Task $task, array $input)
    {
        $input = array_map( 'strip_tags', $input);
        $input['start_date'] = datetime_for_database($input['start_date']);
        $input['end_date'] = datetime_for_database($input['end_date']);
        $input['qty_needed'] = floatval(str_replace(',', '', $input['qty_needed']));
        $result = $task->update($input);
        //dd($result);
        if ($result) {
            return $task->project_id;
        }


        throw new GeneralException(trans('exceptions.backend.tasks.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Task $task
     * @return bool
     * @throws GeneralException
     */
    public function delete(Task $task)
    {
        if ($task->delete() && $task->milestone_jobcard->each->delete()) {
            
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.tasks.delete_error'));
    }
}
