<?php

namespace App\Repositories\Focus\print_design;

use DB;
use Carbon\Carbon;
use App\Models\print_design\PrintDesign;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use App\Utils\MessageUtil;
use Illuminate\Support\Facades\Storage;

/**
 * Class PrintDesignRepository.
 */
class PrintDesignRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = PrintDesign::class;
    protected $file_picture_path;


    /**
     * Constructor.
     */
    public function __construct(MessageUtil $messageUtil)
    {
        $this->file_picture_path = 'img' . DIRECTORY_SEPARATOR . 'designs' . DIRECTORY_SEPARATOR;
        $this->storage = Storage::disk('public');
        $this->messageUtil = $messageUtil;
    }

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = $this->query();
        $q->when(request('customer'), fn($q) => $q->where('customer_id', request('customer')));
        return $q
            ->paginate(6);
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        foreach ($input as $key => $val) {
            if ($key == 'print') {
                if (isset($val['design'])) 
                    $input[$key]['design'] = $this->uploadPicture($val['design'], $this->file_picture_path);
                
            }
        }
        // dd($input);
        // $input = array_map( 'strip_tags', $input);
        if (PrintDesign::create($input['print'])) {
            return true;
        }
        throw new GeneralException(trans('exceptions.backend.printdesigns.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param PrintDesign $PrintDesign
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(PrintDesign $print_design, array $input)
    {
        foreach ($input as $key => $val) {
            if ($key == 'print') {
                if (isset($val['design'])) 
                    $input[$key]['design'] = $this->uploadPicture($val['design'], $this->file_picture_path);
                
            }
        }
        // $input = array_map( 'strip_tags', $input);
    	if ($print_design->update($input['print']))
            return true;

        throw new GeneralException(trans('exceptions.backend.printdesigns.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param PrintDesign $PrintDesign
     * @throws GeneralException
     * @return bool
     */
    public function delete(PrintDesign $print_design)
    {
        if ($print_design->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.printdesigns.delete_error'));
    }

    /*
    * Upload logo image
    */
    public function uploadPicture($logo, $path)
    {

        $image_name = time() . $logo->getClientOriginalName();

        $this->storage->put($path . $image_name, file_get_contents($logo->getRealPath()));

        return $image_name;
    }
}
