<?php

namespace App\Repositories\Focus\paper_width;

use DB;
use Carbon\Carbon;
use App\Models\paper_width\PaperWidth;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PaperWidthRepository.
 */
class PaperWidthRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = PaperWidth::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {

        return $this->query()
            ->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        $input = array_map( 'strip_tags', $input);
        if (PaperWidth::create($input)) {
            return true;
        }
        throw new GeneralException(trans('exceptions.backend.PaperWidths.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param PaperWidth $PaperWidth
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(PaperWidth $paper_width, array $input)
    {
        $input = array_map('strip_tags', $input);
    	if ($paper_width->update($input))
            return true;

        throw new GeneralException(trans('exceptions.backend.PaperWidths.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param PaperWidth $PaperWidth
     * @throws GeneralException
     * @return bool
     */
    public function delete(PaperWidth $paper_width)
    {
        if ($paper_width->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.PaperWidths.delete_error'));
    }
}
