<?php

namespace App\Repositories\Focus\gsm;

use DB;
use Carbon\Carbon;
use App\Models\gsm\GSM;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;

/**
 * Class GSMRepository.
 */
class GSMRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = GSM::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {

        return $this->query()->where('type','2')
            ->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        $input = array_map( 'strip_tags', $input);
        if (GSM::create($input)) {
            return true;
        }
        throw new GeneralException(trans('exceptions.backend.GSMs.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param GSM $GSM
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(GSM $gsm, array $input)
    {
        $input = array_map('strip_tags', $input);
    	if ($gsm->update($input))
            return true;

        throw new GeneralException(trans('exceptions.backend.GSMs.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param GSM $GSM
     * @throws GeneralException
     * @return bool
     */
    public function delete(GSM $gsm)
    {
        if ($gsm->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.GSMs.delete_error'));
    }
}
