<?php

namespace App\Repositories\Focus\goodsreceivenote;

use App\Exceptions\GeneralException;
use App\Models\account\Account;
use App\Models\goodsreceivenote\Goodsreceivenote;
use App\Models\items\GoodsreceivenoteItem;
use App\Models\items\UtilityBillItem;
use App\Models\transaction\Transaction;
use App\Models\product\Product;
use App\Models\transactioncategory\Transactioncategory;
use App\Models\utility_bill\UtilityBill;
use App\Repositories\BaseRepository;
use DB;
use Illuminate\Support\Arr;
use Illuminate\Validation\ValidationException;
use App\Models\paper\Paper;
use App\Models\items\PurchaseorderItem;
use App\Models\paper_bin\PaperBin;
use App\Models\product_bin\ProductBin;

/**
 * Class ProductcategoryRepository.
 */
class GoodsreceivenoteRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = Goodsreceivenote::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = $this->query();

        $q->when(request('supplier_id'), function ($q) {
            $q->where('supplier_id', request('supplier_id'));
        })->when(request('invoice_status'), function ($q) {
            switch (request('invoice_status')) {
                case 'with_invoice':
                    $q->whereNotNull('invoice_no');
                    break;
                case 'without_invoice':
                    $q->whereNull('invoice_no');
                    break;
            }
        });
        
        return $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return \App\Models\goodsreceivenote\Goodsreceivenote $goodsreceivenote
     */
    public function create(array $input)
    {
        //   dd($input);
        DB::beginTransaction();
        
        foreach ($input as $key => $val) {
            if (in_array($key, ['date', 'invoice_date'])) $input[$key] = date_for_database($val);
            if (in_array($key, ['tax_rate', 'subtotal', 'tax', 'total'])) 
                $input[$key] = numberClean($val);
            if (in_array($key, ['qty', 'rate'])) 
                $input[$key] = array_map(fn($v) => numberClean($v), $val);
        }
        $data = Arr::only($input, ['supplier_id','tid','date','dnote','invoice_no','invoice_date',
        'tax_rate','purchaseorder_id','invoice_status','note','subtotal','tax','total']);
        // dd($data);
        // $tid = Goodsreceivenote::max('tid');
        // if ($input['tid'] <= $tid) $input['tid'] = $tid+1;
        $result = Goodsreceivenote::create($data);
        // dd($result);

        // grn items
        $data_items = Arr::only($input, ['qty', 'rate', 'purchaseorder_item_id', 'item_id','item_type','warehouse_id','sku','weight']);
        // dd($data_items);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['qty'] > 0);
        if (!$data_items) throw ValidationException::withMessages(['Cannot generate GRN without product qty!']);
        $paper_item = [];
        $paper_bin = [];
        foreach ($data_items as $i => $item) {
            // dd($item);
            if($item['item_type'] == 'paper'){
                $paper = Paper::find($item['item_id']);
                $purchaseorder_item = PurchaseorderItem::find($item['purchaseorder_item_id']);
                $name = $paper->paper_width ? $paper->paper_width->name : '';
                $paper_id = $item['item_id'];
                $sku = $item['sku'];
                $qty = $item['qty'];
                $unit_id = $paper->unit_id;
                $supplier_id = $paper->supplier_id;
                $warehouse_id = $item['warehouse_id'];
                $ledger_id = $paper->ledger_id;
                $purchase_price = $purchaseorder_item->purchase_price;
                $weight = $item['weight'];
                $paper_item = [
                    'name' => $name,
                    'paper_id' => $paper_id,
                    'sku' => $sku,
                    'qty' => $qty,
                    'unit_id' => $unit_id,
                    'supplier_id' => $supplier_id,
                    'warehouse_id' => $warehouse_id,
                    'ledger_id' => $ledger_id,
                    'purchase_price' => $purchase_price,
                    'weight' => $weight,
                ];
                $product = Product::create($paper_item);
                $paper_bin = [
                    'product_id' => $product->id,
                    'paper_id' => $paper_id,
                    'ref_no' => $result->id,
                    'out' => 0,
                    'in' => 1,
                    'qty' => $qty,
                    'unit' => $unit_id,
                    'type' => 'grn',
                    'supplier_id' => $supplier_id,
                    'value' => $purchase_price,
                    'total_value' => $qty*$purchase_price,
                    'balance' => $qty,
                    'weight' => $weight,
                    'weight_balance' => $weight,
                    'user_id' => auth()->user()->id,
                    'ins' => auth()->user()->ins,
                ];
                PaperBin::create($paper_bin);
                // dd($paper_item);
                $data_items[$i] = array_replace($item, [
                    'goods_receive_note_id' => $result->id,
                    'tax_rate' => $result->tax_rate,
                    'product_paper_id' => $product ? $product->id : 0
                ]);
            }
           else{
            $product = Product::find($item['item_id']);
            $purchaseorder_item = PurchaseorderItem::find($item['purchaseorder_item_id']);
            $product_bin = [
                'product_id' => $item['item_id'],
                'out' => 0,
                'in' => 1,
                'ref_no' => $result->id,
                'qty' => $item['qty'],
                'unit' => $product->unit ? $product->unit->id : 0,
                'type' => 'grn',
                'supplier_id' => $product->supplier_id,
                'value' => $purchaseorder_item->purchase_price,
                'total_value' => $item['qty']*$purchaseorder_item->purchase_price,
                'balance' => $product->qty+$item['qty'],
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
            ];
            ProductBin::create($product_bin);
            $data_items[$i] = array_replace($item, [
                'goods_receive_note_id' => $result->id,
                'tax_rate' => $result->tax_rate,
                'product_paper_id' => 0
            ]);
           }
        }
        //  dd($data_items);
        GoodsreceivenoteItem::insert($data_items);
        
        // increase stock qty
        foreach ($result->items as $i => $item) {
            $po_item = $item->purchaseorder_item;
            //dd($po_item->paper_item->paper_width->name );
            //if (!$po_item) throw ValidationException::withMessages(['Line ' . strval($i+1) . ' related purchase order item does not exist!']);
            $po_item->increment('qty_received', $item->qty);
           // dd($po_item);
            if($item->item_type == 'paper') continue;
            $prod_variation = $po_item->product;

            // dd($prod_variation->units);
            if (isset($prod_variation->units)) {
                foreach ($prod_variation->units as $unit) {
                    if ($unit->id == $po_item['uom']) {
                        if ($unit->unit_type == 'base') {
                            $prod_variation->increment('qty', $item['qty']);
                        } else {
                            $converted_qty = $item['qty'] * $unit->base_ratio;
                            $prod_variation->increment('qty', $converted_qty);
                        }
                    }
                }
                
            } elseif ($prod_variation) $prod_variation->increment('qty', $item['qty']);
           // else throw ValidationException::withMessages(['Product on line ' . strval($i+1) . ' may not exist! Please update it from the Purchase Order number ']);
        }

        // update purchase order status
        $received_goods_qty = $result->items->sum('qty');
        if ($result->purchaseorder) {
            $order_goods_qty = $result->purchaseorder->items->sum('qty');
            if ($received_goods_qty == 0) $result->purchaseorder->update(['status' => 'pending']);
            elseif (round($received_goods_qty) < round($order_goods_qty)) $result->purchaseorder->update(['status' => 'partial']);
            else $result->purchaseorder->update(['status' => 'complete']);
        } //else throw ValidationException::withMessages(['Purchase order does not exist!']);

        /**accounting */
        if ($result->invoice_no) $this->generate_bill($result); // generate bill
        // dd($result->invoice_no);
        // else $this->post_transaction($result); 
        
        if ($result) {
            DB::commit();
            return $result;
        }

        throw new GeneralException('Error Creating Lead');
    }

    /**
     * For updating the respective Model in storage
     *
     * @param \App\Models\goodsreceivenote\Goodsreceivenote $goodsreceivenote
     * @param  array $input
     * @throws GeneralException
     * @return \App\Models\goodsreceivenote\Goodsreceivenote $goodsreceivenote
     */
    public function update(Goodsreceivenote $goodsreceivenote, array $input)
    {
        // dd($input);
        DB::beginTransaction();
        // sanitize
        foreach ($input as $key => $val) {
            if (in_array($key, ['date', 'invoice_date'])) $input[$key] = date_for_database($val);
            if (in_array($key, ['tax_rate', 'subtotal', 'tax', 'total'])) 
                $input[$key] = numberClean($val);
            if (in_array($key, ['qty', 'rate'])) 
                $input[$key] = array_map(fn($v) => numberClean($v), $val);
        }

        $prev_note = $goodsreceivenote->note;
        $result = $goodsreceivenote->update($input);

        // reverse previous stock qty
        foreach ($goodsreceivenote->items as $i => $item) {
            $po_item = $item->purchaseorder_item;
            // dd($item->product_paper);
            // if($item->item_type == 'paper'){
            //     $product_paper = $item->product_paper->delete();
            //     // dd($item->product_paper->paper_bin->each->delete());
            //     $item->product_paper->paper_bin->each->delete();
            //     // dd($product_paper);
            // }
            // if (!$po_item) throw ValidationException::withMessages(['Line ' . strval($i+1) . ' related purchase order item does not exist!']);
            $po_item->decrement('qty_received', $item->qty);
            // apply unit conversion
            $prod_variation = $po_item->product;
            // dd($prod_variation->units);
            if (isset($prod_variation->units)) {
                foreach ($prod_variation->units as $unit) {
                    if ($unit->id == $po_item['uom']) {
                        if ($unit->unit_type == 'base') {
                            $prod_variation->decrement('qty', $item['qty']);
                            // dd($prod_variation);
                        } else {
                            $converted_qty = $item['qty'] * $unit->base_ratio;
                            $prod_variation->decrement('qty', $converted_qty);
                        }
                    }
                }   
            } elseif ($prod_variation) $prod_variation->decrement('qty', $item['qty']);      
            // else throw ValidationException::withMessages(['Product on line ' . strval($i+1) . ' may not exist! Please update it from the Purchase Order number ' . $po_item->purchaseorder->tid]);     
        }

        $bin_items = $goodsreceivenote->product_bin()->get();
        $paper_bin_items = $goodsreceivenote->paper_bin()->get();
        if($bin_items){
            foreach($bin_items as $bin){
                $bin->delete();
            }
        }
        if($paper_bin_items){
            foreach($paper_bin_items as $paper_bin){
                $paper_bin->delete();
            }
        }

        // goods receive note items
        $data_items = Arr::only($input, ['qty', 'rate', 'id','warehouse_id','sku','weight']);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['qty'] > 0);
        foreach ($data_items as $item) {
            $grn_item = GoodsreceivenoteItem::find($item['id']);
            if (!$grn_item) throw ValidationException::withMessages(['GRN item does not exist!']);
            if($grn_item['item_type'] == 'paper'){
                $paper = Paper::find($grn_item['item_id']);
                $purchaseorder_item = PurchaseorderItem::find($grn_item['purchaseorder_item_id']);
                $name = $paper->paper_width ? $paper->paper_width->name : '';
                $paper_id = $grn_item['item_id'];
                $sku = $item['sku'];
                $qty = $item['qty'];
                $unit_id = $paper->unit_id;
                $warehouse_id = $item['warehouse_id'];
                $ledger_id = $paper->ledger_id;
                $supplier_id = $paper->supplier_id;
                $purchase_price = $purchaseorder_item->purchase_price;
                $weight = $item['weight'];
                $paper_item = [
                    'name' => $name,
                    'paper_id' => $paper_id,
                    'sku' => $sku,
                    'qty' => $qty,
                    'unit_id' => $unit_id,
                    'warehouse_id' => $warehouse_id,
                    'ledger_id' => $ledger_id,
                    'supplier_id' => $supplier_id,
                    'purchase_price' => $purchase_price,
                    'weight' => $weight,
                ];
               $product = Product::create($paper_item);
               $paper_bin = [
                    'product_id' => $product->id,
                    'paper_id' => $paper_id,
                    'out' => 0,
                    'in' => 1,
                    'qty' => $qty,
                    'unit' => $unit_id,
                    'type' => 'grn',
                    'supplier_id' => $supplier_id,
                    'value' => $purchase_price,
                    'total_value' => $qty*$purchase_price,
                    'balance' => $qty,
                    'weight' => $weight,
                    'weight_balance' => $weight,
                    'user_id' => auth()->user()->id,
                    'ins' => auth()->user()->ins,
                ];
                PaperBin::create($paper_bin);
                // reverse items qty
                $grn_item->decrement('qty', $grn_item->qty);
                $grn_item->product_paper_id = $product->id;
                // update items qty
                $grn_item->update($item);
                // dd($grn_item);
            }
            else{
                $product = Product::find($grn_item['item_id']);
                $purchaseorder_item = PurchaseorderItem::find($grn_item['purchaseorder_item_id']);
                $product_bin = [
                    'product_id' => $grn_item['item_id'],
                    'ref_no' => $goodsreceivenote->id,
                    'out' => 0,
                    'in' => 1,
                    'qty' => $item['qty'],
                    'unit' => $product->unit ? $product->unit->id : 0,
                    'type' => 'grn',
                    'supplier_id' => $product->supplier_id,
                    'value' => $purchaseorder_item->purchase_price,
                    'total_value' => $item['qty']*$purchaseorder_item->purchase_price,
                    'balance' => $product->qty+$item['qty'],
                    'user_id' => auth()->user()->id,
                    'ins' => auth()->user()->ins,
                ];
                ProductBin::create($product_bin);
                // reverse items qty
                $grn_item->decrement('qty', $grn_item->qty);
                $grn_item->product_paper_id = 0;
                // update items qty
                $grn_item->update($item);
            }
        }

        // increase stock qty with new update 
        $grn_items = $goodsreceivenote->items()->get();
        foreach ($grn_items as $item) {
            $po_item = $item->purchaseorder_item;
            //dd($po_item);
            // if (!$po_item) throw ValidationException::withMessages(['Line ' . strval($i+1) . ' related purchase order item does not exist!']);
            $po_item->increment('qty_received', $item->qty);
            // dd($po_item);
            // apply unit conversion
            $prod_variation = $po_item->product;
            if (isset($prod_variation->units)) {
                foreach ($prod_variation->units as $unit) {
                    if ($unit->id == $po_item['uom']) {
                        if ($unit->unit_type == 'base') {
                            $prod_variation->increment('qty', $item['qty']);
                        } else {
                            $converted_qty = $item['qty'] * $unit->base_ratio;
                            $prod_variation->increment('qty', $converted_qty);
                        }
                    }
                }   
            } elseif ($prod_variation) $prod_variation->increment('qty', $item['qty']);
            // else throw ValidationException::withMessages(['Product on line ' . strval($i+1) . ' may not exist! Please update it from the Purchase Order number ' . $po_item->purchaseorder->tid]);  
        }

        // update purchase order status
        if (!$goodsreceivenote->purchaseorder) throw ValidationException::withMessages(['Purchase Order does not exist!']);
       //dd($goodsreceivenote->purchaseorder);
        $order_goods_qty = $goodsreceivenote->purchaseorder->items->sum('qty');
        $received_goods_qty = $grn_items->sum('qty');
        if ($received_goods_qty == 0) $goodsreceivenote->purchaseorder->update(['status' => 'pending']);
        elseif (round($received_goods_qty) < round($order_goods_qty)) $goodsreceivenote->purchaseorder->update(['status' => 'partial']);
        else $goodsreceivenote->purchaseorder->update(['status' => 'complete']); 
        
        $goodsreceivenote->prev_note = $prev_note;

        /**accounting */
        if ($goodsreceivenote->invoice_no) {
            // generate bill
            $this->generate_bill($goodsreceivenote); 
        } else {
            // grn transaction
            // Transaction::where(['tr_type' => 'grn', 'tr_ref' => $goodsreceivenote->id, 'note' => $goodsreceivenote->prev_note])->delete();
            // $this->post_transaction($goodsreceivenote);
        }

        if ($result) {
            DB::commit();
            return $result;
        }
        
        throw new GeneralException(trans('exceptions.backend.productcategories.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param \App\Models\goodsreceivenote\Goodsreceivenote $goodsreceivenote
     * @throws GeneralException
     * @return bool
     */
    public function delete(Goodsreceivenote $goodsreceivenote)
    {     
        DB::beginTransaction();

        $grn_bill = $goodsreceivenote->bill;
        if ($grn_bill) throw ValidationException::withMessages(['Goods Receive Note is attached to Bill ' . gen4tid('', $grn_bill->tid)]);

        // decrease inventory stock 
        foreach ($goodsreceivenote->items as $item) {
            $po_item = $item->purchaseorder_item;
            if ($po_item) {
                $po_item->decrement('qty_received', $item->qty);
                // apply unit conversion
                $prod_variation = $po_item->product;
                if (isset($prod_variation->units)) {
                    foreach ($prod_variation->units as $unit) {
                        if ($unit->id == $po_item['uom']) {
                            if ($unit->unit_type == 'base') {
                                $prod_variation->decrement('qty', $po_item['qty']);
                            } else {
                                $converted_qty = $po_item['qty'] * $unit->base_ratio;
                                $prod_variation->decrement('qty', $converted_qty);
                            }
                        }
                    }   
                } elseif ($prod_variation) $prod_variation->decrement('qty', $po_item['qty']);
            }
        }
        $bin_items = $goodsreceivenote->product_bin()->get();
        $paper_bin_items = $goodsreceivenote->paper_bin()->get();
        if($bin_items){
            foreach($bin_items as $bin){
                $bin->delete();
            }
        }
        if($paper_bin_items){
            foreach($paper_bin_items as $paper_bin){
                $paper_bin->delete();
            }
        }

        // delete received items
        $goodsreceivenote->items()->delete();

        // update purchase order status
        if ($goodsreceivenote->purchaseorder) {
            $order_goods_qty = $goodsreceivenote->purchaseorder->items->sum('qty');
            $received_goods_qty = $goodsreceivenote->items()->sum('qty');
            if ($received_goods_qty == 0) $goodsreceivenote->purchaseorder->update(['status' => 'pending']);
            elseif (round($received_goods_qty) < round($order_goods_qty)) $goodsreceivenote->purchaseorder->update(['status' => 'partial']);
            else $goodsreceivenote->purchaseorder->update(['status' => 'complete']); 
        }
        
        // clear transactions
        // $goodsreceivenote->transactions()->delete();
        //aggregate_account_transactions();
          
        if ($goodsreceivenote->delete()) {
            DB::commit(); 
            return true;
        }
  
        throw new GeneralException(trans('exceptions.backend.productcategories.delete_error'));
    }


    /**
     * Generate Bill For Goods Receive with invoice
     * 
     * @param Goodsreceivenote $grn
     * @return void
     */
    public function generate_bill($grn)
    {
        $bill_data = [
            'supplier_id' => $grn->supplier_id,
            'doc_ref' => $grn->invoice_no,
            'doc_type_ref' => 'invoice',
            'document_type' => 'goods_receive_note',
            'ref_id' => $grn->id,
            'date' => $grn->invoice_date,
            'due_date' => $grn->invoice_date,
            'subtotal' => $grn->subtotal,
            'tax_rate' => $grn->tax_rate,
            'tax' => $grn->tax,
            'total' => $grn->total,
            'note' => $grn->note,
        ];

        $grn_items = $grn->items()->get()->map(fn($v) => [
            'ref_id' => $v->id,
            'note' => $v->purchaseorder_item? $v->purchaseorder_item->name : '',
            'qty' => $v->qty,
            'subtotal' => $v->qty * $v->rate,
            'tax' => $v->qty * $v->rate * ($v->tax_rate / 100),
            'total' => $v->qty * $v->rate * (1 + $v->tax_rate / 100)
        ])->toArray();       
        
        $bill = UtilityBill::where(['ref_id' => $grn->id, 'document_type' => 'goods_receive_note'])->first();
        if ($bill) {
            // update bill
            $bill->update($bill_data);
            foreach ($grn_items as $item) {
                $new_item = UtilityBillItem::firstOrNew(['invoice_id' => $bill->id,'ref_id' => $item['ref_id']]);
                $new_item->fill($item);
                $new_item->save();
            }

            // accounting
            // Transaction::where(['tr_type' => 'bill', 'tr_ref' => $bill->id, 'note' => $bill->prev_note])->delete();
        } else {
            // create bill
            $bill_data['tid'] = UtilityBill::where('ins', auth()->user()->ins)->max('tid') + 1;
            $bill = UtilityBill::create($bill_data);

            $bill_items_data = array_map(function ($v) use($bill) {
                $v['invoice_id'] = $bill->id;
                return $v;
            }, $grn_items);
            UtilityBillItem::insert($bill_items_data);
        }        
        // accounting
        // $this->invoiced_grn_transaction($bill);
    }

    /**
     * Post Goods Received With Invoice Transactions
     */
    public function invoiced_grn_transaction($utility_bill)
    {
        // debit Inventory Account
        $account = Account::where('system', 'stock')->first(['id']);
        $tr_category = Transactioncategory::where('code', 'bill')->first(['id', 'code']);
        $tid = Transaction::where('ins', auth()->user()->ins)->max('tid') + 1;
        $dr_data = [
            'tid' => $tid,
            'account_id' => $account->id,
            'trans_category_id' => $tr_category->id,
            'debit' => $utility_bill->subtotal,
            'tr_date' => $utility_bill->date,
            'due_date' => $utility_bill->due_date,
            'user_id' => $utility_bill->user_id,
            'note' => $utility_bill->note,
            'ins' => $utility_bill->ins,
            'tr_type' => $tr_category->code,
            'tr_ref' => $utility_bill->id,
            'user_type' => 'supplier',
            'is_primary' => 1
        ];
        Transaction::create($dr_data);

        // debit TAX
        if ($utility_bill->tax > 0) {
            $account = Account::where('system', 'tax')->first(['id']);
            $cr_data = array_replace($dr_data, [
                'account_id' => $account->id,
                'debit' => $utility_bill->tax,
            ]);
            Transaction::create($cr_data);
        }

        // credit Accounts Payable (creditors)
        unset($dr_data['debit'], $dr_data['is_primary']);
        $account = Account::where('system', 'payable')->first(['id']);
        $cr_data = array_replace($dr_data, [
            'account_id' => $account->id,
            'credit' => $utility_bill->total,
        ]);    
        Transaction::create($cr_data);
        aggregate_account_transactions();
    }

    /**
     * Post Goods Received Account transactions
     * 
     * @param \App\Models\goodsreceivenote\Goodsreceivenote $grn
     * @return void
     */
    public function post_transaction($grn)
    {
        // credit Uninvoiced Goods Received Note (liability)
        $account = Account::where('system', 'grn')->first(['id']);
        $tr_category = Transactioncategory::where('code', 'grn')->first(['id', 'code']);
        $tid = Transaction::where('ins', auth()->user()->ins)->max('tid') + 1;
        $cr_data = [
            'tid' => $tid,
            'account_id' => $account->id,
            'trans_category_id' => $tr_category->id,
            'credit' => $grn->subtotal,
            'tr_date' => $grn->date,
            'due_date' => $grn->date,
            'user_id' => $grn->user_id,
            'note' => $grn->note,
            'ins' => $grn->ins,
            'tr_type' => $tr_category->code,
            'tr_ref' => $grn->id,
            'user_type' => 'supplier',
            'is_primary' => 1
        ];
        Transaction::create($cr_data);

        // debit Inventory (Stock) Account
        unset($cr_data['credit'], $cr_data['is_primary']);
        $account = Account::where('system', 'stock')->first(['id']);
        $dr_data = array_replace($cr_data, [
            'account_id' => $account->id,
            'debit' => $grn->subtotal,
        ]);    
        Transaction::create($dr_data);
       // aggregate_account_transactions();
    }
}