<?php

namespace App\Repositories\Focus\debitnote;

use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use App\Models\debitnote\DebitNote;
use App\Models\items\DebitNoteItem;
use App\Repositories\Focus\JournalEntryService;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

/**
 * Class PurchaseorderRepository.
 */
class DebitNoteRepository extends BaseRepository
{
    use JournalEntryService;
    /**
     * Associated Repository Model.
     */
    const MODEL = DebitNote::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = DebitNote::query();

        return $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);        
        foreach ($input as $key => $value) {
            if ($key == 'date') $input[$key] = date_for_database($value);
            $keys = [
                'amount', 'frx_rate', 'tax_rate', 'taxable', 'tax', 'total', 'frx_amount', 
                'frx_taxable', 'frx_tax', 'frx_total',
                'prod_qty', 'prod_rate',
            ];
            if (in_array($key, $keys)) {
                if (is_array($value)) $input[$key] = array_map(fn($v) => numberClean($v), $value);
                else $input[$key] = numberClean($value);
            }
        }
        $data = array_diff_key($input, array_flip(['prod_id', 'prod_qty', 'prod_rate']));
        $data_items = Arr::only($input, ['prod_id', 'prod_qty', 'prod_rate']);
        $data_items = array_filter(modify_array($data_items), fn($v) => $v['prod_qty'] > 0);
        // dd($data, $data_items);

        DB::beginTransaction();
        
        $debitnote = DebitNote::create($data);
        // return goods
        $data_items = array_map(function($v) use($debitnote) {
            return [
                'payment_id' => $debitnote->id,
                'invoice_id' => $debitnote->invoice_id,
                'product_id' => $v['prod_id'],
                'qty' => $v['prod_qty'],
                'rate' => $v['prod_rate'],
                'amount' => $v['prod_qty'] * $v['prod_rate'],
                'user_id' => $debitnote->user_id,
                'ins' => $debitnote->ins,
            ];
        }, $data_items);
        DebitNoteItem::insert($data_items);
        
        // purchases return accounting
        $debitnote['debitnote_id'] = $debitnote->id;
        $this->sales_return_acc($debitnote, 'store');

        if ($debitnote) {
            DB::commit();
            return $debitnote;
        }
    }

    // 
    public function update($debitnote, array $input)
    {
        dd($input);
        // DB::beginTransaction();
    }


    /**
     * For deleting the respective model from storage
     *
     * @param DebitNote $debitnote
     * @throws GeneralException
     * @return bool
     */
    public function delete($debitnote)
    {
        DB::beginTransaction();

        $this->sales_return_acc($debitnote, 'delete');

        $debitnote->items()->delete();
        if ($debitnote->delete()) {
            DB::commit();
            return true;
        };
    }    
}