<?php

namespace App\Repositories\Focus\customer;

use App\Models\account\Account;
use App\Models\customer\Customer;
use App\Models\invoice\Invoice;
use App\Models\transaction\Transaction;

trait CustomerStatement
{
    /**
     * Statement on Account
     * 
     */
    public function getTransactionsForDataTable($customer_id = 0)
    {      
        $account = Account::where('system', 'receivable')->first();
        $subledger_ids = $account->subledger_accounts->map(fn($v) => $v['id']);
        // return collect();      

        $q = Transaction::whereIn('ledger_id', $subledger_ids)
            ->where('customer_id', request('customer_id'))
            ->where(function($q) {
                $q->whereHas('manual_journal')
                ->orWhereHas('invoice')
                ->orWhereHas('deposit')
                ->orWhereHas('creditnote');
            });
        return $q->get();

        
        $params = ['customer_id' => request('customer_id', $customer_id)];
        $customer = Customer::find(request('customer_id'), ['id', 'open_balance_note']);

        $q = Transaction::whereHas('account', function ($q) { 
            $q->where('system', 'receivable');  
        })->where(function ($q) use($params) {
            $q->where('tr_type', 'inv')->whereHas('invoice', function ($q1) use($params) { 
                $q1->where($params); 
            })->orWhere('tr_type', 'pmt')->whereHas('paidinvoice', function ($q1) use($params) {
                $q1->where($params);
            })->orWhere('tr_type', 'withholding')->whereHas('withholding', function ($q1) use($params) {
                $q1->where($params);
            })->orWhere('tr_type', 'cnote')->whereHas('creditnote', function ($q1) use($params) {
                $q1->where($params);
            });
        })->orwhere(function ($q) use($customer) {
            $note = "%{$customer->id}-customer Account Opening Balance {$customer->open_balance_note}%";
            $q->where('tr_type', 'genjr')->where('debit', '>', 0)->where('note', 'LIKE', $note);
        });       
        
        // on date filter
        if (request('start_date') && request('is_transaction')) {
            $from = date_for_database(request('start_date'));
            $tr_ids = $q->pluck('id')->toArray();
            
            $params = ['id', 'tr_date', 'tr_type', 'note', 'debit', 'credit'];
            $transactions = Transaction::whereIn('id', $tr_ids)->whereBetween('tr_date', [$from, date('Y-m-d')])->get($params);
            // compute balance brought foward as of start date
            $bf_transactions = Transaction::whereIn('id', $tr_ids)->where('tr_date', '<', $from)->get($params);
            $debit_balance = $bf_transactions->sum('debit') - $bf_transactions->sum('credit');
            if ($debit_balance) {
                $record = (object) array(
                    'id' => 0,
                    'tr_date' => date('Y-m-d', strtotime($from . ' - 1 day')),
                    'tr_type' => 'balance',
                    'note' => '** Balance Brought Foward ** ',
                    'debit' => $debit_balance > 0 ? $debit_balance : 0,
                    'credit' => $debit_balance < 0 ? ($debit_balance * -1) : 0,
                );
                // merge brought foward balance with the rest of the transactions
                $transactions = collect([$record])->merge($transactions);
            }

            return $transactions;
        }

        return $q->get();
    }

    /**
     * Statement on Invoice
     * 
     */
    public function getStatementForDataTable($customer_id = 0)
    {
        $invoices = Invoice::where('customer_id', request('customer_id', $customer_id))
            ->with(['payments', 'withholding_payments', 'creditnotes', 'debitnotes'])
            ->get();

        $i = 0;
        $statement = collect();
        foreach ($invoices as $invoice) {
            $i++;
            $invoice_id = $invoice->id;
            $tid = $invoice->tid_code;
            $inv_record = (object) array(
                'id' => $i,
                'date' => $invoice->date,
                'type' => 'invoice',
                'note' => "({$tid}) {$invoice->note}",
                'debit' => +$invoice->total,
                'credit' => 0,
                'invoice_id' => $invoice_id
            );

            $payments = collect();
            foreach ($invoice->payments as $pmt) {
                $i++;
                $reference = @$pmt->deposit->reference;
                $mode = @$pmt->deposit->doc_reference;
                $pmt_tid = @$pmt->deposit->tid_code;
                $account = @$pmt->deposit->account->name;
                $amount = numberFormat(@$pmt->deposit->amount);
                $record = (object) array(
                    'id' => $i,
                    'date' => @$pmt->deposit->date,
                    'type' => 'deposit',
                    'note' => "({$tid}) {$pmt_tid} reference: {$reference} mode: {$mode} account: {$account} amount: {$amount}",
                    'debit' => 0,
                    'credit' => +$pmt->amount,
                    'invoice_id' => $invoice_id,
                    'payment_item_id' => $pmt->id
                );
                $payments->add($record);
            }    

            // $withholdings = collect();
            // foreach ($invoice->withholding_payments as $pmt) {
            //     $i++;
            //     $note = $pmt->withholding->reference . ' - ' . $pmt->withholding->certificate . ' ' . $pmt->withholding->note;
            //     $record = (object) array(
            //         'id' => $i,
            //         'date' => $pmt->withholding->date,
            //         'type' => 'withholding',
            //         'note' => '(' . $tid . ')' . ' ' . $note,
            //         'debit' => 0,
            //         'credit' => $pmt->paid,
            //         'invoice_id' => $invoice_id,
            //         'withholding_item_id' => $pmt->id 
            //     );
            //     $withholdings->add($record);
            // }  

            $creditnotes = collect();
            foreach ($invoice->creditnotes as $cnote) {
                $i++;
                $record = (object) array(
                    'id' => $i,
                    'date' => $cnote->date,
                    'type' => 'credit_note',
                    'note' => "({$tid}) {$cnote->note}",
                    'debit' => 0,
                    'credit' => +$cnote->total,
                    'invoice_id' => $invoice_id,
                    'creditnote_id' => $cnote->id
                );
                $creditnotes->add($record);
            }   

            $debitnotes = collect();
            foreach ($invoice->debitnotes as $dnote) {
                $i++;
                $record = (object) array(
                    'id' => $i,
                    'date' => $dnote->date,
                    'type' => 'debit_note',
                    'note' => "({$tid}) {$dnote->note}",
                    'dedit' => +$dnote->total,
                    'credit' => 0,
                    'invoice_id' => $invoice_id,
                    'debitnote_id' => $dnote->id
                );
                $debitnotes->add($record);
            }   

            $statement->add($inv_record);
            $statement = $statement->merge($payments);
            $statement = $statement->merge($creditnotes);
            $statement = $statement->merge($debitnotes);
            // $statement = $statement->merge($withholdings);
        }
        return $statement;
    }
}