<?php

namespace App\Repositories\Focus\creditnote;

use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use App\Models\creditnote\CreditNote;
use App\Models\items\CreditNoteItem;
use App\Repositories\Focus\JournalEntryService;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

/**
 * Class PurchaseorderRepository.
 */
class CreditNoteRepository extends BaseRepository
{
    use JournalEntryService;
    /**
     * Associated Repository Model.
     */
    const MODEL = CreditNote::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = CreditNote::query();

        return $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);        
        foreach ($input as $key => $value) {
            if ($key == 'date') $input[$key] = date_for_database($value);
            $keys = [
                'amount', 'frx_rate', 'tax_rate', 'taxable', 'tax', 'total', 'frx_amount', 
                'frx_taxable', 'frx_tax', 'frx_total',
                'prod_qty', 'prod_rate',
            ];
            if (in_array($key, $keys)) {
                if (is_array($value)) $input[$key] = array_map(fn($v) => numberClean($v), $value);
                else $input[$key] = numberClean($value);
            }
        }
        $data = array_diff_key($input, array_flip(['prod_id', 'prod_qty', 'prod_rate']));
        $data_items = Arr::only($input, ['prod_id', 'prod_qty', 'prod_rate']);
        $data_items = array_filter(modify_array($data_items), fn($v) => $v['prod_qty'] > 0);
        // dd($data, $data_items);

        DB::beginTransaction();
        
        $creditnote = CreditNote::create($data);
        // return goods
        $data_items = array_map(function($v) use($creditnote) {
            return [
                'payment_id' => $creditnote->id,
                'invoice_id' => $creditnote->invoice_id,
                'product_id' => $v['prod_id'],
                'qty' => $v['prod_qty'],
                'rate' => $v['prod_rate'],
                'amount' => $v['prod_qty'] * $v['prod_rate'],
                'user_id' => $creditnote->user_id,
                'ins' => $creditnote->ins,
            ];
        }, $data_items);
        CreditNoteItem::insert($data_items);
        // increase stock qty
        foreach ($creditnote->items as $item) {
            if ($item->product) {
                $item->product->increment('qty', $item->qty);
            }
        }





        // temp ledger id
        $creditnote['items'] = $creditnote->items->map(function($v) {
            $mod_v = $v->replicate();
            $mod_v['ledger_id'] = @$v->product->ledger_id ?: 15; // stockable account
            return $mod_v;
        });
        if ($creditnote->invoice) $creditnote->invoice->account_id = 16; // repair account

        // sales return accounting
        $creditnote['creditnote_id'] = $creditnote->id;
        $this->sales_return_acc($creditnote, 'store');

        if ($creditnote) {
            DB::commit();
            return $creditnote;
        }
    }

    // 
    public function update($creditnote, array $input)
    {
        dd($input);
        // DB::beginTransaction();
    }


    /**
     * For deleting the respective model from storage
     *
     * @param CreditNote $creditnote
     * @throws GeneralException
     * @return bool
     */
    public function delete($creditnote)
    {
        DB::beginTransaction();

        $this->sales_return_acc($creditnote, 'delete');

        $creditnote->items()->delete();
        if ($creditnote->delete()) {
            DB::commit();
            return true;
        };
    }    
}