<?php

namespace App\Repositories\Focus\brand;

use App\Exceptions\GeneralException;
use App\Models\brand\Brand;
use App\Repositories\BaseRepository;
use Illuminate\Support\Arr;
use DB;

class BrandRepository extends BaseRepository
{

    const MODEL = Brand::class;

    public function getForDataTable()
    {
        $q = $this->query();
        return $q->get();
    }

    public function create(array $input)
    {
        DB::beginTransaction();
        $brand = Brand::create($input);

        DB::commit();

       if ($brand) return $brand;

        throw new GeneralException('Error creating brand.');
    }
    public function update($brand, array $input)
    {

        DB::beginTransaction();
        $brand->update($input);

        DB::commit();

       if ($brand) return $brand;

        throw new GeneralException('Error updating brand.');
    }

    public function delete($brand)
    {
        DB::beginTransaction();

        $brand->delete();
        DB::commit();

        throw new GeneralException('Error deleting brand.');
    }
}
