<?php

namespace App\Repositories\Focus\bom;

use App\Exceptions\GeneralException;
use App\Models\brand\Brand;
use App\Models\car_model\CarModel;
use App\Repositories\BaseRepository;
use Illuminate\Support\Arr;
use App\Models\bom\BoM;
use App\Models\bom\BoMItem;
use DB;
use App\Models\jobcard\JobCard;

class BoMRepository extends BaseRepository
{

    const MODEL = BoM::class;

    public function getForDataTable()
    {
        $q = $this->query();
        return $q->get();
    }

    public function create(array $input)
    {

        DB::beginTransaction();
        $data = $input['data'];
        if($data['jobcard_id']){
            $data['bom_status'] = JobCard::find($data['jobcard_id'])->job_status;
        }
        // dd($data['bom_status']);
        foreach ($data as $key => $value) {
            if(in_array($key, ['bom_date']))
                $data[$key] = date_for_database($value);
            if(in_array($key, ['total_bom']))
                $data[$key] = floatval(str_replace(',', '', $value));
        }
        $result = BoM::create($data);
        if($result->jobcard_id){
            $jobcard = JobCard::find($result->jobcard_id);
            $jobcard->bom_id = $result->id;
            $jobcard->update();
        }
        // bom line items
        $data_items = $input['data_items'];
        $data_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'bom_id' => $result->id, 
                'ins' => $result->ins,
                'purchase_price' =>  floatval(str_replace(',', '', $v['purchase_price'])),
            ]);
        }, $data_items);
        BoMItem::insert($data_items);
        if ($result) {
            DB::commit();
            return $result;
        }

        throw new GeneralException('Error creating Bill of Materials.');
    }
    public function update($bom, array $input)
    {
        DB::beginTransaction();
        $data = $input['data'];
        foreach ($data as $key => $val) {
            if (in_array($key, ['bom_date']))
                $data[$key] = date_for_database($val);
            if (in_array($key, ['total_bom'])) 
                $data[$key] = floatval(str_replace(',', '', $val));
        }   
        $result = $bom->update($data);

        $data_items = $input['data_items'];
        //dd($data_items);
        // remove omitted items
        $bom_id = array_map(function ($v) { 
            // dd($v);
            return $v['id']; }, $data_items);
        $bom->bom_items()->whereNotIn('id', $bom_id)->delete();
        // dd($bom->id);
        // create or update items
        foreach($data_items as $item) {
            $bom_item = BoMItem::firstOrNew(['id' => $item['id']]);         
            $bom_item->fill(array_replace($item, [
                'bom_id' => $bom->id,
                'purchase_price' =>  floatval(str_replace(',', '', $item['purchase_price'])),
            ]));
            //dd($bom_item);
            if (!$bom_item->id) unset($bom_item->id);
            unset($bom_item->id);
            $bom_item->save();
        }

        if ($result) {
            DB::commit();
            return $bom;      
        }

        throw new GeneralException('Error updating Bill of Materials.');
    }

    public function delete($bom)
    {
        if ($bom->delete() && $bom->bom_items->each->delete()) return true;
        throw new GeneralException('Error deleting Bom.');
    }
}
