<?php

namespace App\Repositories\Focus\assembly;

use App\Exceptions\GeneralException;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Repositories\BaseRepository;
use DB;

class AssemblyStationRepository extends BaseRepository
{

    const MODEL = AssemblyStation::class;

    public function getForDataTable()
    {
        $q = $this->query();

        return $q->get();
    }

    public function create(array $input)
    {
        DB::beginTransaction();
        $result =  AssemblyStation::create($input);
        DB::commit();
        if ($result) return $result;

        throw new GeneralException('Error Creating Station');
    }
    public function update($assembly_station, array $input)
    {
        DB::beginTransaction();
        if ($assembly_station->update($input)) {
            DB::commit();
            return true;
        }

        throw new GeneralException('Error Updating Assembly Station');
    }

    public function delete($assembly_station)
    {
        DB::beginTransaction();
        if($assembly_station->delete()){
            DB::commit();
            return true;
        }

        throw new GeneralException('Error deleting assembly station');
    }
}
