<?php

namespace App\Repositories\Focus\assembly;

Use App\Models\assembly\assembly_station_operator\AssemblyStationOperator;
use App\Repositories\BaseRepository;
use Carbon\Carbon;
use App\Models\assembly\assembled_product\AssembledProductItem;
class AssembledProductsReportRepository extends BaseRepository
{

    const MODEL = AssembledProductItem::class;

    public function getForDataTable()
    {
        $q = $this->query();
        $q->when(request('product'), function ($q) {
                $q->where('product_id', request('product'));
        });

        $q->when(request('assemble_date'), function ($q) {
            $q->whereHas('assembled_product', function($q){
                $q->where('assemble_date', request('assemble_date'));
            });
        });
        return $q->get();
    }
}
