<?php

namespace App\Repositories\Focus\assembly;

use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use DB;
use App\Models\assembly\assembled_product\AssembledProduct;
use App\Models\assembly\assembled_product\AssembledProductItem;
use Illuminate\Support\Arr;


class AssembledProductRepository extends BaseRepository
{

    const MODEL = AssembledProduct::class;

    public function getForDataTable()
    {
        $q = $this->query();
        $q->when(request('assemble_date'), function($q){
            $q->where('assemble_date', request('assemble_date'));
        });

        return $q->get();
    }

    public function create(array $input)
    {
        DB::beginTransaction();
        $result =  AssembledProduct::create($input);

        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'assembled_quantity','uom']);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['assembled_quantity'] > 0);

        foreach ($data_items as $i => $item) {
            $data_items[$i] = array_replace($item, [
                'assembled_product_id' =>$result->id,
                'ins' => $input['ins'],
                'user_id' => $input['user_id'],
                'created_at' => $result->created_at,
                'updated_at' => $result->updated_at,
            ]);
        }
        AssembledProductItem::insert($data_items);

        foreach ($data_items as $i => $item) {
            DB::table('product_variations')->where('parent_id',$item['product_id'])->increment('qty', $item['assembled_quantity']);
        }

        DB::commit();
        if ($result) return $result;

        throw new GeneralException('Error adding assembled products.');
    }
    public function update($assembled_product, array $input)
    {
        DB::beginTransaction();

        $assembled_product->update($input);

        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'assembled_quantity','uom']);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['assembled_quantity'] > 0);

        foreach ($data_items as $i => $item) {
            $data_items[$i] = array_replace($item, [
                'assembled_product_id' =>$assembled_product->id,
                'ins' => $input['ins'],
                'user_id' => $input['user_id'],
                'created_at' => $assembled_product->created_at,
                'updated_at' => $assembled_product->updated_at,
            ]);
        }

        foreach($assembled_product->assembled_product_items as $mi){
            DB::table('product_variations')->where('parent_id',$mi->product_id)->increment('qty', $mi->assembled_quantity);
        }

        AssembledProductItem::insert($data_items);

        DB::commit();
        if ($assembled_product) return $assembled_product;

        throw new GeneralException('Error updating assembled products.');
    }

    public function delete($assembled_product)
    {
        DB::beginTransaction();
        if($assembled_product->delete()){
            DB::commit();
            return true;
        }

        throw new GeneralException('Error deleting assembled products');
    }
}
