<?php

namespace App\Models\work_order;

use App\Models\ModelTrait;
use App\Models\work_order\Traits\WorkOrderAttribute;
use App\Models\work_order\Traits\WorkOrderRelationship;
use Illuminate\Database\Eloquent\Model;

class WorkOrder extends Model
{
    use ModelTrait, WorkOrderAttribute, WorkOrderRelationship;

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'work_orders';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Constructor of Model
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($invoice) {
            $invoice->fill([
                'tid' => WorkOrder::max('tid')+1,
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
            ]);
            return $invoice;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', auth()->user()->ins);
        });
    }
}
