<?php

namespace App\Models\work_order\Traits;

use App\Models\currency\Currency;
use App\Models\customer\Customer;
use App\Models\invoice\Invoice;
use App\Models\work_order\WorkOrderItem;

trait WorkOrderRelationship
{
    public function items() 
    {
        return $this->hasMany(WorkOrderItem::class);
    }

    public function customer() 
    {
        return $this->belongsTo(Customer::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function invoice()
    {
        return $this->hasOne(Invoice::class);
    }
}
