<?php

namespace App\Models\waste_management;

use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;
use App\Models\waste_management\Traits\WasteManagementItemsAttribute;
use App\Models\waste_management\Traits\WasteManagementItemsRelationship;

class WasteManagementItems extends Model
{
    use ModelTrait,  WasteManagementItemsAttribute, WasteManagementItemsRelationship;

    protected $table = 'waste_management_items';

    protected $fillable = [
            
        ];

    protected $attributes = [];

    protected $dates = [
            'created_at',
            'updated_at'
        ];

    protected $guarded = [
            'id'
        ];

    public function __construct(array $attributes = [])
        {
            parent::__construct($attributes);
        }
    protected static function boot()
        {
            parent::boot();

            static::creating(function ($instance) {
                $instance->ins = auth()->user()->ins;
                return $instance;
            });

            static::addGlobalScope('ins', function ($builder) {
                $builder->where('ins', '=', auth()->user()->ins);
            });
        }
}
