<?php

namespace App\Models\transaction;

use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\transaction\Traits\TransactionAttribute;
use App\Models\transaction\Traits\TransactionRelationship;

class Transaction extends Model
{
    use ModelTrait,
        TransactionAttribute,
        TransactionRelationship {
        // TransactionAttribute::getEditButtonAttribute insteadof ModelTrait;
    }

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'journal_entries';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Lifecycle events
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->user_id = auth()->user()->id;
            $instance->ins = auth()->user()->ins;
            return $instance;
        });
        
        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
