<?php

namespace App\Models\transaction\Traits;

use App\Models\hrm\Hrm;
use App\Models\invoice\Invoice;
use App\Models\invoice_payment\InvoicePayment;
use App\Models\manualjournal\Journal;
use App\Models\transaction\TransactionOrigin;

/**
 * Class TransactionRelationship
 */
trait TransactionRelationship
{
    public function manual_journal() 
    {
        return $this->hasOneThrough(Journal::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'mnl_journal_id')
        ->withoutGlobalScopes();
    }

    public function bank_charge()
    {
        return $this->hasOneThrough(Invoice::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'charge_id')
        ->withoutGlobalScopes();
    }

    public function bank_transfer()
    {
        return $this->hasOneThrough(Invoice::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'bank_transfer_id')
        ->withoutGlobalScopes();
    }

    public function invoice()
    {
        return $this->hasOneThrough(Invoice::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'invoice_id')
        ->whereNotNull('customer_id')->withoutGlobalScopes();
    }

    public function bill()
    {
        return $this->hasOneThrough(Invoice::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'invoice_id')
        ->whereNotNull('supplier_id')->withoutGlobalScopes();
    }

    public function deposit()
    {
        return $this->hasOneThrough(InvoicePayment::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'payment_id')
        ->where('type', 'deposit')->withoutGlobalScopes();
    }

    public function payment()
    {
        return $this->hasOneThrough(InvoicePayment::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'payment_id')
            ->where('type', 'payment')->withoutGlobalScopes();
    }

    public function creditnote()
    {
        return $this->hasOneThrough(InvoicePayment::class, TransactionOrigin::class, 'journal_entry_id', 'id', 'id', 'payment_id')
        ->where('type', 'creditnote')->withoutGlobalScopes();
    }

    public function account()
    {
        return $this->belongsTo('App\Models\account\Account', 'ledger_id');
    }

    public function customer()
    {
        return $this->belongsTo('App\Models\customer\Customer', 'customer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('App\Models\supplier\Supplier', 'supplier_id');
    }

    public function employee()
    {
        return $this->belongsTo(Hrm::class, 'payer_id', 'id');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\transactioncategory\Transactioncategory', 'trans_category_id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\Access\User\User')->withoutGlobalScopes();
    }
}
