<?php

namespace App\Models\prospectcallresolved;


use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\prospectcallresolved\Traits\ProspectCallResolvedAttribute;
use App\Models\prospectcallresolved\Traits\ProspectCallResolvedRelationship;

class ProspectCallResolved extends Model
{
    use ModelTrait,
        ProspectCallResolvedAttribute,
        ProspectCallResolvedRelationship {
        
    }

    /**
     * NOTE : If you want to implement Soft Deletes in this model,
     * then follow the steps here : https://laravel.com/docs/5.4/eloquent#soft-deleting
     */

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'prospects_calls_resolved';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Constructor of Model
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    /**
     * model life cycle event listeners
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->user_id = auth()->user()->id;
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        
    }
}
