<?php

namespace App\Models\productconversion;

use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;
use App\Models\productconversion\Traits\ProductConversionAttribute;
use App\Models\productconversion\Traits\ProductConversionRelationship;

class ProductConversion extends Model
{
    use ModelTrait, ProductConversionAttribute, ProductConversionRelationship;

    protected $table = 'product_conversions';

    protected $fillable = ['in_house_product','in_house_product_quantity','raw_material','raw_material_quantity'];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];

    protected $guarded = [
        'id'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
