<?php

namespace App\Models\productcombination;

use Illuminate\Database\Eloquent\Model;
use App\Models\productcombination\Traits\ProductProcessingAttribute;
use App\Models\productcombination\Traits\ProductProcessingRelationship;
use App\Models\ModelTrait;

class ProductProcessing extends Model
{
    use ModelTrait, ProductProcessingAttribute, ProductProcessingRelationship;

    protected $table = 'product_processings';

    protected $fillable = [
        'product_id',
        'product_quantity',
        'processing_product',
        'processing_product_quantity',
        'ins',
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];

    protected $guarded = [
        'id'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }

}
