<?php

namespace App\Models\productcombination;

use Illuminate\Database\Eloquent\Model;
use App\Models\product\Product;
use App\Models\ModelTrait;
use  App\Models\productcombination\Traits\ProductCombinationRelationship;


class ProductCombination extends Model

{
    use ModelTrait, ProductCombinationRelationship;

    protected $table = 'product_combinations';

    protected $fillable = [
        'product_id',
        'combining_products',
        'combining_products_quantity',
        'ins',
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];

    protected $guarded = [
        'id'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
