<?php

namespace App\Models\product\Traits;

use App\Models\items\GoodsreceivenoteItem;
use App\Models\product\ProductVariation;
use App\Models\productcategory\Productcategory;
use App\Models\productvariable\Productvariable;
use App\Models\warehouse_shelves\WarehouseShelf;
use App\Models\warehouse_row\WareHouseRow;
use App\Models\productcombination\Productcombination;
use App\Models\productcombination\ProductProcessing;
use App\Models\assembly\material_issuing\MaterialIssuingItems;
use App\Models\brand\Brand;
use App\Models\warehouse\Warehouse;
use App\Models\product_bin\ProductBin;
use App\Models\paper_bin\PaperBin;

/**
 * Class ProductRelationship
 */
trait ProductRelationship
{
    public function grn_item()
    {
        return $this->hasOne(GoodsreceivenoteItem::class, 'item_id');
    }

    public function units()
    {
        return $this->belongsToMany(Productvariable::class, 'product_unit', 'product_id', 'product_variable_id');
    }

    public function unit()
    {
        return $this->belongsTo(Productvariable::class, 'unit_id');
    }

    public function standard()
    {
        return $this->hasOne(ProductVariation::class, 'parent_id')->withoutGlobalScopes();
    }

    public function variations()
    {
        return $this->hasMany(ProductVariation::class, 'parent_id')->withoutGlobalScopes();
    }

    public function category()
    {
        return $this->hasOne(Productcategory::class, 'id', 'productcategory_id')->withoutGlobalScopes();
    }

    public function subcategory()
    {
        return $this->hasOne(Productcategory::class, 'id', 'sub_cat_id');
    }

    public function record()
    {
        return $this->hasMany(ProductVariation::class);
    }

    public function record_one()
    {
        return $this->hasOne(ProductVariation::class);
    }

    public function warehouse_row(){
        return $this->belongsToMany(WarehouseRow::class);
    }

    public function warehouse_shelf(){
        return $this->belongsToMany(WarehouseShelf::class);
    }
    public function product_combination(){
        return $this->hasMany(ProductCombination::class);
    }
    public function product_processor(){
        return $this->hasOne(ProductProcessing::class);
    }

    public function material_issuing_item(){
        return $this->belongsTo(MaterialIssuingItems::class);
    }

    public function brand(){
        return $this->belongsTo(Brand::class);
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }
    public function product_bin()
    {
        return $this->hasMany(ProductBin::class, 'product_id')->latest();
    }
    public function paper_bin()
    {
        return $this->hasMany(PaperBin::class, 'product_id');
    }
}
