<?php

namespace App\Models\print_design\Traits;

use App\Models\customer\Customer;
use App\Models\jobcard\JobCard;
use App\Models\jobcard\JobCardAttachment;
/**
 * Class DepartmentRelationship
 */
trait PrintDesignRelationship
{
     public function customer(){
        return $this->belongsTo(Customer::class, 'customer_id');
     }
     public function attachment(){
        return $this->hasManyThrough(JobCard::class, JobCardAttachment::class, 'design_id','id','id', 'jobcard_id')->withoutGlobalScope('ins');
     }

     public function attach()
     {
         return $this->hasMany(JobCardAttachment::class, 'design_id');
     }
}
