<?php

namespace App\Models\paper\Traits;

use App\Models\hrm\HrmMeta;
use App\Models\gsm\GSM;
use App\Models\supplier\Supplier;
use App\Models\paper_width\PaperWidth;
use App\Models\paper\PaperName;
use App\Models\productvariable\Productvariable;
use App\Models\product\Product;
use App\Models\account\Account;
/**
 * Class paperRelationship
 */
trait PaperRelationship
{
     public function paper_width()
     {
        return $this->belongsTo(PaperName::class, 'paper_width_id');
     }
     public function gsm()
     {
        return $this->belongsTo(PaperName::class, 'gsm_id');
     }
     public function supplier()
     {
        return $this->belongsTo(Supplier::class, 'supplier_id');
     }
     public function unit()
    {
        return $this->belongsTo(Productvariable::class, 'unit_id');
    }
    public function product() {
      return $this->hasMany(Product::class, 'paper_id');
    }
    public function paper_product() {
      return $this->hasMany(Product::class, 'paper_id')->groupBy(['supplier_id','gsm_id']);
    }
    public function account()
    {
       return $this->belongsTo(Account::class, 'ledger_id');
    }
}
