<?php

namespace App\Models\manualjournal\Traits;

use App\Models\items\JournalItem;
use App\Models\transaction\Transaction;
use App\Models\transaction\TransactionOrigin;

trait JournalRelationship
{
    public function transactions()
    {
        return $this->hasManyThrough(Transaction::class, TransactionOrigin::class, 'mnl_journal_id', 'id', 'id', 'journal_entry_id')
            ->withoutGlobalScopes();
    }

    public function transaction_origins()
    {
        return $this->hasMany(TransactionOrigin::class, 'mnl_journal_id');
    }

    public function items()
    {
        return $this->hasMany(JournalItem::class, 'journal_id');
    }
}
