<?php

namespace App\Models\lpo;

use App\Models\branch\Branch;
use App\Models\customer\Customer;
use App\Models\quote\Quote;
use Illuminate\Database\Eloquent\Model;
use App\Models\project\Project;
use App\Models\project\ProjectLpo;

class Lpo extends Model
{
    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'lpos';

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    public function quotes()
    {
        return $this->hasMany(Quote::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
    public function project()
    {
        return $this->hasOneThrough(Project::class, ProjectLpo::class, 'lpo_id', 'id', 'id', 'project_id')->withoutGlobalScopes();
    }
}
