<?php

namespace App\Models\jobcard\Traits;

use App\Models\hrm\Hrm;
use App\Models\hrm\HrmMeta;
use App\Models\customer\Customer;
use App\Models\bom\BoM;
use App\Models\project\Project;
use App\Models\project\ProjectJobCard;
use App\Models\jobcard\JobCardItem;
use App\Models\jobcard\JobCardProcess;
use App\Models\dispatch\Dispatch;
use App\Models\project\Task;
use App\Models\project\MilestoneJobCard;
use App\Models\jobcard\JobCardAttachment;

/**
 * Class jobcardRelationship
 */
trait JobCardRelationship
{
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }
    public function bom()
    {
        return $this->belongsTo(BoM::class, 'bom_id');
    }
    public function items()
    {
        return $this->hasMany(JobCardItem::class, 'jobcard_id');
    }
    public function processes()
    {
        return $this->hasMany(JobCardProcess::class, 'jobcard_id')->orderBy('process_id','asc');
    }
    public function project()
    {
        return $this->hasOneThrough(Project::class, ProjectJobCard::class, 'jobcard_id', 'id', 'id', 'project_id')->withoutGlobalScopes();
    }
    public function task()
    {
        return $this->hasOneThrough(Task::class, MilestoneJobCard::class, 'jobcard_id', 'id', 'id', 'task_id')->withoutGlobalScopes();
    }

    public function dispatch()
    {
        return $this->hasMany(Dispatch::class, 'jobcard_id');
    }
    public function attachments()
    {
        return $this->hasMany(JobCardAttachment::class, 'jobcard_id');
    }
}
