<?php

namespace App\Models\invoice\Traits;

use App\Models\creditnote\CreditNote;
use App\Models\currency\Currency;
use App\Models\project\ProjectRelations;
use App\Models\lead\Lead;
use App\Models\customer\Customer;
use App\Models\items\InvoiceItem;
use App\Models\items\InvoicePaymentItem;
use App\Models\items\TaxReportItem;
use App\Models\items\WithholdingItem;
use App\Models\manualjournal\Journal;
use App\Models\quote\Quote;
use App\Models\transaction\Transaction;
use App\Models\transaction\TransactionOrigin;
use App\Models\work_order\WorkOrder;

/**
 * Class InvoiceRelationship
 */
trait InvoiceRelationship
{
    public function transactions()
    {
        return $this->hasManyThrough(Transaction::class, TransactionOrigin::class, 'invoice_id', 'id', 'id', 'journal_entry_id')
        ->withoutGlobalScopes();
    }

    public function manual_journal()
    {
        return $this->hasOne(Journal::class);
    }

    public function work_order()
    {
        return $this->belongsTo(WorkOrder::class);
    }

    public function invoice_tax_reports()
    {
        return $this->hasMany(TaxReportItem::class);
    }

    public function withholding_payments()
    {
        return $this->hasMany(WithholdingItem::class);
    }

    public function payments()
    {
        return $this->hasMany(InvoicePaymentItem::class);
    }

    public function creditnotes()
    {
        return $this->hasMany(CreditNote::class)->whereNull('supplier_id');
    }

    public function debitnotes()
    {
        return $this->hasMany(CreditNote::class)->whereNull('customer_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
        // return $this->belongsTo('App\Models\customer\Customer')->withoutGlobalScopes();
    }

    public function products()
    {
        return $this->hasMany('App\Models\items\InvoiceItem')->withoutGlobalScopes();
    }

    public function user()
    {
        return $this->belongsTo('App\Models\Access\User\User')->withoutGlobalScopes();
    }
    public function term()
    {
        return $this->belongsTo('App\Models\term\Term')->withoutGlobalScopes();
    }

    public function attachment()
    {
        return $this->hasMany('App\Models\items\MetaEntry', 'rel_id')->where('rel_type', '=', 1)->withoutGlobalScopes();
    }

    public function project()
    {
        return $this->belongsTo(ProjectRelations::class, 'id',  'rid')->where('related', '=', 7);
    }

    public function client()
    {
        return $this->hasOneThrough(Customer::class, Lead::class, 'id', 'id', 'lead_id', 'client_id')->withoutGlobalScopes();
    }

    public function branch()
    {
        return $this->hasOneThrough(Branch::class, Lead::class, 'id', 'id', 'lead_id', 'branch_id')->withoutGlobalScopes();
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function items(){
        return $this->hasMany(InvoiceItem::class, 'invoice_id');
    }
}
