<?php

namespace App\Models\customer\Traits;

use App\Models\branch\Branch;
use App\Models\client_product\ClientProduct;
use App\Models\customergroup\Customergroup;
use App\Models\customergroup\CustomerGroupEntry;
use App\Models\lead\Lead;
use App\Models\manualjournal\Journal;
use App\Models\transaction\Transaction;
use App\Models\project\Project;
use App\Models\quote\Quote;
use App\Models\vehicle_receiving\VehicleReceiving;

/**
 * Class CustomerRelationship
 */
trait CustomerRelationship
{
    public function opening_balance_invoices()
    {
        return $this->hasMany('App\Models\invoice\Invoice', 'customer_id')->whereNull('ledger_id');
    }

    public function manual_journals()
    {
        return $this->hasMany(Journal::class, 'customer_id');
    }

    public function customer_groups()
    {
        return $this->hasManyThrough(Customergroup::class, CustomerGroupEntry::class, 'customer_id', 'id', 'id', 'customer_group_id')
            ->withoutGlobalScopes();
    }





    function quotes()
    {
        return $this->hasMany(Quote::class);
    }

    public function products()
    {
        return $this->hasMany(ClientProduct::class);
    }

    public function client_products()
    {
        return $this->hasMany(ClientProduct::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class, 'client_id');
    }

    public function branches()
    {
        return $this->hasMany(Branch::class);
    }



    public function primary_group()
    {
        return $this->hasOne('App\Models\customergroup\CustomerGroupEntry')->oldest();
    }

    public function invoices()
    {
        return $this->hasMany('App\Models\invoice\Invoice')->orderBy('id', 'DESC');
    }

    public function amount()
    {
        return $this->hasMany(Transaction::class, 'payer_id');
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function chassis(){
        return $this->hasMany(VehicleReceiving::class);
    }
}
