<?php

namespace App\Models\customer\Traits;

use App\Models\items\InvoicePaymentItem;

/**
 * Class CustomerAttribute.
 */
trait CustomerAttribute
{
    // Make your attributes functions here
    // Further, see the documentation : https://laravel.com/docs/5.4/eloquent-mutators#defining-an-accessor


    /**
     * Action Button Attribute to show in grid
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return '
         '.$this->getViewButtonAttribute("manage-customer", "biller.customers.show").'
                '.$this->getEditButtonAttribute("edit-customer", "biller.customers.edit").'
                '.$this->getDeleteButtonAttribute("delete-customer", "biller.customers.destroy",'table').'
                ';
    }

    /**
     * On Account Balance
     * 
     * @return string
     */
    public function getOnAccountBalanceAttribute()
    {
        $overpayment = InvoicePaymentItem::whereNull('invoice_id')
            ->whereHas('deposit', fn($q) => $q->where('customer_id', $this->id))
            ->sum('amount');
        $overpayment_allocations = InvoicePaymentItem::whereNotNull('item_payment_id')
            ->whereHas('deposit', fn($q) => $q->where('customer_id', $this->id))
            ->sum('amount');
        return $overpayment - $overpayment_allocations;
    }
}
