<?php

namespace App\Models\creditnote\Traits;

/**
 * Class ProductcategoryAttribute.
 */
trait CreditNoteAttribute
{
    /**
     * Action Button Attribute to show in grid
     * @return string
     */
     public function getActionButtonsAttribute()
    {
        return 
            $this->getViewButtonAttribute("manage-credit-note", "biller.creditnotes.show")
            .' '. $this->getEditButtonAttribute("edit-credit-note", "biller.creditnotes.edit")
            .' '. $this->getDeleteButtonAttribute("delete-credit-note", "biller.creditnotes.destroy");
    }

    /**
     * Transaction ID code
     * 
     * @return float
     */
    public function getTidCodeAttribute()
    {
        return gen4tid('CN-', $this->tid);
    }
}
