<?php

namespace App\Models\charge;

use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\charge\Traits\ChargeAttribute;
use App\Models\charge\Traits\ChargeRelationship;

class Charge extends Model
{
    use ModelTrait,
        ChargeAttribute,
        ChargeRelationship {
        // ProductcategoryAttribute::getEditButtonAttribute insteadof ModelTrait;
    }

    /**
     * NOTE : If you want to implement Soft Deletes in this model,
     * then follow the steps here : https://laravel.com/docs/5.4/eloquent#soft-deleting
     */

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'charges';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * model life cycle event listeners
     * @return void
     */    
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($charge) {
            $charge->fill([
                'tid' => Charge::max('tid')+1,
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
            ]);
            return $charge;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', auth()->user()->ins);
        });
    }
}
