<?php

namespace App\Models\car_model;

use App\Models\car_model\Traits\CarModelAttribute;
use App\Models\car_model\Traits\CarModelRelationship;
use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;

class CarModel extends Model
{
    use ModelTrait, CarModelAttribute, CarModelRelationship;
    protected $table = 'car_model';

    protected $fillable = [
        'name','code','year','description','user_id', 'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
