<?php

namespace App\Models\brand;

use App\Models\brand\Traits\BrandAttribute;
use App\Models\brand\Traits\BrandRelationship;
use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;

class Brand extends Model
{
    use ModelTrait, BrandAttribute,BrandRelationship;

    protected $table = 'brands';

    protected $fillable = [
        'name','code','description','user_id', 'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot(); 

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
