<?php

namespace App\Models\bom;

use App\Models\bom\Traits\BoMItemRelationship;
use Illuminate\Database\Eloquent\Model;

class BoMItem extends Model
{
    use BoMItemRelationship;
    protected $table = 'bill_of_materials_items';

    protected $fillable = [
       
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
