<?php

namespace App\Models\bom;

use App\Models\bom\Traits\BoMAttribute;
use App\Models\bom\Traits\BoMRelationship;
use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;

class BoM extends Model
{
    use ModelTrait, BoMAttribute, BoMRelationship;
    protected $table = 'bill_of_materials';

    protected $fillable = [

    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->fill([
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
                'tid' => BoM::getTid() + 1,
            ]);
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
    static function getTid()
    {
        return BoM::where('ins', auth()->user()->ins)->max('tid');
    }
}
