<?php

namespace App\Models\assembly\material_issuing\Traits;

use App\Models\Access\User\User;
use App\Models\assembly\material_issuing\MaterialIssuingItems;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Models\warehouse\Warehouse;

trait MaterialIssuingRelationship
{
    public function material_issuing_items(){
        return $this->hasMany(MaterialIssuingItems::class);
    }

    public function assembly_station(){
        return $this->belongsTo(AssemblyStation::class, 'station');
    }
    public function warehouse_station(){
        return $this->belongsTo(Warehouse::class,'warehouse_id');
    }

    public function issued_by(){
        return $this->belongsTo(User::class, 'user_id');
    }

    public function issued_to(){
        return $this->belongsTo(User::class, 'issued_to');
    }
}
