<?php

namespace App\Models\assembly\material_issuing\Traits;

use App\Models\Access\User\User;
use App\Models\assembly\material_issuing\MaterialIssuing;
use App\Models\product\Product;
use App\Models\productvariable\Productvariable;

trait MaterialIssuingItemsRelationship
{
    public function material_issuing(){
        return $this->belongsTo(MaterialIssuing::class);
    }

    public function product(){
        return $this->belongsTo(Product::class, 'product_id');
    }
    public function unit_of_measure(){
        return $this->belongsTo(Productvariable::class, 'uom');
    }
    public function issued_by(){
        return $this->belongsTo(User::class, 'user_id');
    }
    public function issued_to(){
        return $this->belongsTo(User::class, 'user_id');
    }
    // public function warehouse(){
    //     return $this->belongsTo(User::class, 'user_id');
    // }
}
