<?php

namespace App\Models\assembly\material_issuing;

use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;
use App\Models\assembly\material_issuing\Traits\MaterialIssuingItemsAttribute;
use App\Models\assembly\material_issuing\Traits\MaterialIssuingItemsRelationship;

class MaterialIssuingItems extends Model
{
    use ModelTrait, MaterialIssuingItemsAttribute, MaterialIssuingItemsRelationship;

    protected $table = 'material_issuing_items';

    protected $fillable = [
        'material_issuing_id',
        'product_id',
        'current_stock_quantity',
        'quantity_issued',
        'warehouse_id',
        'uom',
        'unit_cost',
        'total_cost',
        'user_id',
        'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
