<?php

namespace App\Models\assembly\material_issuing;

use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;
use App\Models\assembly\material_issuing\Traits\MaterialIssuingAttribute;
use App\Models\assembly\material_issuing\Traits\MaterialIssuingRelationship;

class MaterialIssuing extends Model
{
    use ModelTrait, MaterialIssuingAttribute, MaterialIssuingRelationship;

    protected $table = 'material_issuing';

    protected $fillable = [
        'tid','station','warehouse_id','issue_date', 'notes','amount', 'user_id', 'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
