<?php

namespace App\Models\assembly\assembly_station_operator;

use App\Models\assembly\assembly_station_operator\Traits\AssemblyStationOperatorAttribute;
use App\Models\assembly\assembly_station_operator\Traits\AssemblyStationOperatorRelationship;
use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;


class AssemblyStationOperator extends Model
{
    use ModelTrait, AssemblyStationOperatorAttribute, AssemblyStationOperatorRelationship;

    protected $table = 'assembly_station_operators';

    protected $fillable = [
        'station','operator','status','notes','user_id', 'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
