<?php

namespace App\Models\assembly\assembled_product;

use App\Models\assembly\assembled_product\Traits\AssembledProductItemAttribute;
use App\Models\assembly\assembled_product\Traits\AssembledProductItemRelationship;
use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;

class AssembledProductItem extends Model
{
    use ModelTrait, AssembledProductItemAttribute , AssembledProductItemRelationship;

    protected $table = 'assembled_product_items';

    protected $fillable = [
        'assembled_product_id',
        'product_id',
        'current_stock_quantity',
        'assembled_quantity',
        'uom',
        'user_id',
        'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
