<?php

namespace App\Models\account;

use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\account\Traits\AccountAttribute;
use App\Models\account\Traits\AccountRelationship;

class Account extends Model
{
    use ModelTrait, AccountAttribute, AccountRelationship;
        
    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'journal_ledgers';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * model life cycle event listeners
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($account) {
            $account_type = AccountType::find($account->ledger_type_id);
            $number = Account::where('ledger_type', $account_type->category)->max('number');
            $account->fill([
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
                'ledger_type' => $account_type->category,
                'number' => $number ? $number+1 : $account_type->number,
            ]);
            return $account;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->whereNull('ins')->orWhere('ins', auth()->user()->ins);
        });
    }

    /**
     * Account subledgers
     * 
     * @return string
     */
    public function getSubledgersAttribute()
    {
        return Account::where('ledger_id', $this->id)->get();
    }
}
