<?php

namespace App\Http\Responses\Focus\supplier;

use App\Models\account\Account;
use App\Models\currency\Currency;
use App\Models\customergroup\Customergroup;
use Illuminate\Contracts\Support\Responsable;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\supplier\Supplier
     */
    protected $supplier;

    /**
     * @param App\Models\supplier\Supplier $supplier
     */
    public function __construct($supplier)
    {
        $this->supplier = $supplier;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $suppliergroups = Customergroup::all();
        $account = Account::where('system', 'payable')->first();  
        $currencies = Currency::get();

        return view('focus.suppliers.edit', compact('account', 'suppliergroups', 'currencies'))->with(['supplier' => $this->supplier]);
    }
}