<?php

namespace App\Http\Responses\Focus\stock_adjustment;

use App\Models\product\Product;
use App\Models\productvariable\Productvariable;
use Illuminate\Contracts\Support\Responsable;

class EditResponse implements Responsable
{
    protected $stockAdjustment;

    public function __construct($stockAdjustment)
    {
        $this->stockAdjustment = $stockAdjustment;
    }

    public function toResponse($request)
    {
        $products = Product::all();
        $productvariables = Productvariable::all();
        return view('focus.stock_adjustment.edit', compact('products','productvariables'))->with(['stockAdjustment' => $this->stockAdjustment]);
    }
}
