<?php

namespace App\Http\Responses\Focus\quote;

use App\Models\additional\Additional;
use App\Models\bank\Bank;
use App\Models\customer\Customer;
use App\Models\quote\Quote;
use Illuminate\Contracts\Support\Responsable;
use App\Models\lead\Lead;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $ins = auth()->user()->ins;
        $prefixes = prefixesArray(['quote', 'lead'], $ins);

        $words['title'] = 'Quote';
        if (request('doc_type') == 'maintenance') $words['title'] = 'Quote';
            
        $leads = Lead::where('status', 0)->orderBy('id', 'desc')->get();
        $additionals = Additional::all();
        $price_customers = Customer::whereHas('products')->get(['id', 'company']);
        
        $common_params = ['leads', 'words', 'additionals', 'price_customers', 'prefixes'];

        // create quote
        return view('focus.quotes.create', compact(...$common_params))
            ->with(bill_helper(2, 4));
    }
}
