<?php

namespace App\Http\Responses\Focus\project;

use App\Models\account\Account;
use App\Models\branch\Branch;
use App\Models\hrm\Hrm;
use App\Models\misc\Misc;
use Illuminate\Contracts\Support\Responsable;
use App\Models\customer\Customer;
use App\Models\jobcard\JobCard;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\project\Project
     */
    protected $project;

    /**
     * @param App\Models\project\Project $projects
     */
    public function __construct($project)
    {
        $this->project = $project;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $project = $this->project;

        $mics = Misc::all();
        $employees = Hrm::all();
        $accounts = Account::get();
        $branch = Branch::find($project->branch_id, ['id', 'name']);
        $customers = Customer::all(['id', 'company']);
        $jobcards = JobCard::all(['id', 'jobcard_no']);

        return view('focus.projects.edit', compact('mics', 'employees', 'project', 'branch','customers','jobcards'));
    }
}